# Clon de Product Hunt

Una aplicación web fullstack que clona las funcionalidades básicas de Product Hunt, desarrollada con Node.js, Express, EJS y MySQL para ser compatible con hosting compartido con cPanel y LiteSpeed.

## Características

- 🔐 Sistema de autenticación (registro, login con JWT)
- 📦 Publicación de productos (nombre, descripción, URL, imagen)
- 👍 Sistema de votos
- 💬 Sistema de comentarios
- 📋 Listado de productos por fecha y popularidad
- 🔍 Búsqueda de productos

## Requisitos

- Node.js 14+ y npm
- MySQL 5.7+
- Hosting compartido con soporte para Node.js (cPanel + LiteSpeed)

## Instalación Local

1. Clona este repositorio:
   ```bash
   git clone https://github.com/tu-usuario/product-hunt-clone.git
   cd product-hunt-clone
   ```

2. Instala las dependencias:
   ```bash
   npm install
   ```

3. Crea un archivo `.env` basado en `.env.example`:
   ```bash
   cp .env.example .env
   ```
   
4. Edita el archivo `.env` con tus credenciales de base de datos y configuraciones.

5. Crea la base de datos en MySQL:
   ```bash
   mysql -u tu_usuario -p < install.sql
   ```

6. Inicia la aplicación:
   ```bash
   npm start
   ```
   
7. Para desarrollo, puedes usar:
   ```bash
   npm run dev
   ```

## Estructura del Proyecto

```
.
├── app.js                # Punto de entrada principal
├── controllers/          # Controladores
├── models/               # Modelos de datos
├── middlewares/          # Middlewares personalizados
├── routes/               # Rutas de la aplicación
├── public/               # Archivos estáticos
│   ├── css/              # Hojas de estilo
│   ├── js/               # JavaScript del cliente
│   └── uploads/          # Imágenes subidas
├── views/                # Plantillas EJS
│   ├── auth/             # Vistas de autenticación
│   ├── layouts/          # Layouts principales
│   ├── partials/         # Componentes reutilizables
│   └── products/         # Vistas de productos
├── .env.example          # Ejemplo de variables de entorno
├── install.sql           # Script SQL para crear la base de datos
└── package.json          # Dependencias y scripts
```

## Despliegue en cPanel

1. Comprime tu proyecto (excluyendo node_modules):
   ```bash
   zip -r product-hunt-clone.zip . -x "node_modules/*"
   ```

2. Sube el archivo ZIP a tu hosting y descomprímelo.

3. En cPanel, ve a "Setup Node.js App" y configura:
   - Node.js version: 14+ (o la disponible más reciente)
   - Application mode: Production
   - Application root: La ruta donde descomprimiste el proyecto
   - Application URL: La URL donde quieres que se acceda a tu app
   - Application startup file: app.js

4. Crea la base de datos en cPanel:
   - Ve a "MySQL Database Wizard"
   - Crea una nueva base de datos y usuario
   - Importa el archivo install.sql

5. Configura las variables de entorno en el panel de Node.js:
   - Copia las variables del archivo .env.example
   - Actualiza con tus credenciales de base de datos

6. Inicia la aplicación desde el panel de cPanel.

## Usuario de Prueba

- Email: demo@example.com
- Contraseña: password123

## Licencia

MIT 