const { body } = require('express-validator');

// Validación para registro de usuario
exports.registerValidator = [
  body('name')
    .notEmpty().withMessage('El nombre es obligatorio')
    .isLength({ min: 3 }).withMessage('El nombre debe tener al menos 3 caracteres'),
  
  body('email')
    .notEmpty().withMessage('El correo electrónico es obligatorio')
    .isEmail().withMessage('Ingrese un correo electrónico válido'),
  
  body('password')
    .notEmpty().withMessage('La contraseña es obligatoria')
    .isLength({ min: 6 }).withMessage('La contraseña debe tener al menos 6 caracteres'),
  
  body('confirm_password')
    .notEmpty().withMessage('Debe confirmar la contraseña')
    .custom((value, { req }) => {
      if (value !== req.body.password) {
        throw new Error('Las contraseñas no coinciden');
      }
      return true;
    })
];

// Validación para inicio de sesión
exports.loginValidator = [
  body('email')
    .notEmpty().withMessage('El correo electrónico es obligatorio')
    .isEmail().withMessage('Ingrese un correo electrónico válido'),
  
  body('password')
    .notEmpty().withMessage('La contraseña es obligatoria')
];

// Validación para crear producto
exports.productValidator = [
  body('name')
    .notEmpty().withMessage('El nombre del producto es obligatorio')
    .isLength({ min: 3, max: 100 }).withMessage('El nombre debe tener entre 3 y 100 caracteres'),
  
  body('description')
    .notEmpty().withMessage('La descripción es obligatoria')
    .isLength({ min: 10 }).withMessage('La descripción debe tener al menos 10 caracteres'),
  
  body('url')
    .notEmpty().withMessage('La URL es obligatoria')
    .isURL().withMessage('Ingrese una URL válida')
];

// Validación para comentarios
exports.commentValidator = [
  body('text')
    .notEmpty().withMessage('El comentario no puede estar vacío')
    .isLength({ min: 2, max: 500 }).withMessage('El comentario debe tener entre 2 y 500 caracteres')
]; 