const { DataTypes } = require('sequelize');
const { sequelize } = require('./db');
const User = require('./User');
const Product = require('./Product');

const Comment = sequelize.define('Comment', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  text: {
    type: DataTypes.TEXT,
    allowNull: false
  }
});

// Relaciones
Comment.belongsTo(User, { foreignKey: 'userId', as: 'author' });
Comment.belongsTo(Product, { foreignKey: 'productId' });

User.hasMany(Comment, { foreignKey: 'userId' });
Product.hasMany(Comment, { foreignKey: 'productId' });

module.exports = Comment; 