const { DataTypes } = require('sequelize');
const { sequelize } = require('./db');
const User = require('./User');
const Category = require('./Category');

const Product = sequelize.define('Product', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  name: {
    type: DataTypes.STRING,
    allowNull: false
  },
  description: {
    type: DataTypes.TEXT,
    allowNull: false
  },
  url: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      isUrl: true
    }
  },
  image: {
    type: DataTypes.STRING,
    allowNull: false
  },
  votesCount: {
    type: DataTypes.INTEGER,
    defaultValue: 0
  }
});

// Relación con Usuario (creador del producto)
Product.belongsTo(User, { foreignKey: 'userId', as: 'creator' });
User.hasMany(Product, { foreignKey: 'userId' });

// Relación con Categoría
Product.belongsTo(Category, { foreignKey: 'categoryId', as: 'category' });
Category.hasMany(Product, { foreignKey: 'categoryId' });

module.exports = Product; 