const { DataTypes } = require('sequelize');
const { sequelize } = require('./db');
const Product = require('./Product');
const Tag = require('./Tag');

const ProductTag = sequelize.define('ProductTag', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  }
}, {
  timestamps: false
});

// Relación muchos a muchos entre Producto y Etiqueta
Product.belongsToMany(Tag, { through: ProductTag, as: 'tags' });
Tag.belongsToMany(Product, { through: ProductTag, as: 'products' });

module.exports = ProductTag; 