const { DataTypes } = require('sequelize');
const { sequelize } = require('./db');
const User = require('./User');
const Product = require('./Product');

const Vote = sequelize.define('Vote', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  }
}, {
  indexes: [
    {
      unique: true,
      fields: ['userId', 'productId']
    }
  ]
});

// Relaciones
Vote.belongsTo(User, { foreignKey: 'userId' });
Vote.belongsTo(Product, { foreignKey: 'productId' });

User.hasMany(Vote, { foreignKey: 'userId' });
Product.hasMany(Vote, { foreignKey: 'productId' });

module.exports = Vote; 