// Funcionalidad para votar por productos en la página principal
document.addEventListener('DOMContentLoaded', function() {
  // Manejar votos en la página principal
  const voteButtons = document.querySelectorAll('.vote-btn:not(.disabled)');
  
  if (voteButtons.length > 0) {
    voteButtons.forEach(button => {
      button.addEventListener('click', function() {
        const productId = this.getAttribute('data-product-id');
        
        // Mostrar estado de carga
        const originalText = this.innerHTML;
        this.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>';
        this.disabled = true;
        
        fetch(`/products/${productId}/vote`, {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          }
        })
        .then(response => response.json())
        .then(data => {
          if (data.success) {
            // Actualizar contador de votos
            const voteCountElement = this.closest('.col-md-2').querySelector('.vote-count');
            if (voteCountElement) {
              voteCountElement.textContent = data.votesCount;
            }
            
            // Deshabilitar botón
            this.classList.add('disabled');
            this.setAttribute('disabled', true);
            this.innerHTML = '<i class="fa-solid fa-check me-1"></i>Votado';
            
            // Mostrar notificación
            showNotification('Voto registrado correctamente', 'success');
          } else {
            this.innerHTML = originalText;
            this.disabled = false;
            showNotification(data.message, 'danger');
          }
        })
        .catch(error => {
          console.error('Error:', error);
          this.innerHTML = originalText;
          this.disabled = false;
          showNotification('Error al procesar el voto', 'danger');
        });
      });
    });
  }
  
  // Añadir animación a las tarjetas de productos en la página principal
  const productCards = document.querySelectorAll('.product-card');
  if (productCards.length > 0) {
    productCards.forEach((card, index) => {
      card.style.opacity = '0';
      card.style.transform = 'translateY(20px)';
      card.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
      
      setTimeout(() => {
        card.style.opacity = '1';
        card.style.transform = 'translateY(0)';
      }, 50 * index);
    });
  }
  
  // Mejorar la experiencia de la barra de búsqueda
  const searchInput = document.querySelector('input[name="query"]');
  if (searchInput) {
    // Enfocar automáticamente en la página de búsqueda
    if (window.location.pathname === '/search') {
      searchInput.focus();
    }
    
    // Añadir evento para enviar el formulario al presionar Enter
    searchInput.addEventListener('keypress', function(e) {
      if (e.key === 'Enter') {
        e.preventDefault();
        this.closest('form').submit();
      }
    });
  }
});

// Función para mostrar notificaciones - Definida globalmente para poder usarla en todas las páginas
function showNotification(message, type) {
  const notification = document.createElement('div');
  notification.className = `alert alert-${type} alert-dismissible fade show notification-toast`;
  notification.innerHTML = `
    ${message}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
  `;
  
  // Estilos para la notificación
  notification.style.position = 'fixed';
  notification.style.top = '20px';
  notification.style.right = '20px';
  notification.style.zIndex = '1050';
  notification.style.minWidth = '250px';
  notification.style.boxShadow = '0 0.5rem 1rem rgba(0, 0, 0, 0.15)';
  
  document.body.appendChild(notification);
  
  // Eliminar automáticamente después de 3 segundos
  setTimeout(() => {
    notification.classList.remove('show');
    setTimeout(() => {
      notification.remove();
    }, 150);
  }, 3000);
} 