/**
 * Script para la página de búsqueda avanzada
 */
document.addEventListener('DOMContentLoaded', function() {
  // Referencia al formulario de búsqueda
  const searchForm = document.querySelector('form[action="/search"]');
  
  if (searchForm) {
    // Limpiar filtros
    const resetButton = document.createElement('button');
    resetButton.type = 'button';
    resetButton.className = 'btn btn-outline-secondary me-2';
    resetButton.innerHTML = '<i class="fa-solid fa-xmark me-1"></i>Limpiar filtros';
    resetButton.addEventListener('click', function() {
      // Limpiar campos del formulario
      document.getElementById('query').value = '';
      document.getElementById('category').value = '';
      document.getElementById('sortBy').value = 'date';
      
      // Enviar formulario
      searchForm.submit();
    });
    
    // Añadir botón al formulario
    const submitButton = searchForm.querySelector('button[type="submit"]');
    const buttonContainer = submitButton.parentElement;
    buttonContainer.insertBefore(resetButton, submitButton);
    
    // Animación al cargar resultados
    const productCards = document.querySelectorAll('.product-card');
    productCards.forEach((card, index) => {
      // Añadir una pequeña animación con retraso progresivo
      card.style.opacity = '0';
      card.style.transform = 'translateY(20px)';
      card.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
      
      setTimeout(() => {
        card.style.opacity = '1';
        card.style.transform = 'translateY(0)';
      }, 100 * index);
    });
  }
}); 