const express = require('express');
const router = express.Router();
const authController = require('../controllers/authController');
const { registerValidator, loginValidator } = require('../middlewares/validators');
const { isAuthenticated, checkAuth } = require('../middlewares/auth');

// Rutas de registro
router.get('/register', checkAuth, authController.showRegisterForm);
router.post('/register', registerValidator, authController.register);

// Rutas de inicio de sesión
router.get('/login', checkAuth, authController.showLoginForm);
router.post('/login', loginValidator, authController.login);

// Ruta de cierre de sesión
router.get('/logout', isAuthenticated, authController.logout);

module.exports = router; 