const express = require('express');
const router = express.Router();
const categoryController = require('../controllers/categoryController');
const { checkAuth } = require('../middlewares/auth');

// Listar todas las categorías
router.get('/', checkAuth, categoryController.getCategories);

// Ver productos de una categoría
router.get('/:slug', checkAuth, categoryController.getCategoryProducts);

module.exports = router; 