const express = require('express');
const router = express.Router();
const indexController = require('../controllers/indexController');
const searchController = require('../controllers/searchController');
const { checkAuth } = require('../middlewares/auth');

// Ruta principal
router.get('/', checkAuth, indexController.getHomePage);

// Ruta para búsqueda avanzada
router.get('/search', checkAuth, searchController.advancedSearch);

module.exports = router; 