const express = require('express');
const router = express.Router();
const notificationController = require('../controllers/notificationController');
const { checkAuth } = require('../middlewares/auth');

// Middleware para proteger todas las rutas
router.use(checkAuth);

// Obtener notificaciones del usuario
router.get('/', notificationController.getUserNotifications);

// Marcar notificación como leída
router.post('/:id/read', notificationController.markAsRead);

// Marcar todas las notificaciones como leídas
router.post('/read-all', notificationController.markAllAsRead);

// Eliminar notificación
router.delete('/:id', notificationController.deleteNotification);

module.exports = router; 