const express = require('express');
const router = express.Router();
const tagController = require('../controllers/tagController');
const { checkAuth } = require('../middlewares/auth');

// Listar todas las etiquetas
router.get('/', checkAuth, tagController.getTags);

// Ver productos de una etiqueta
router.get('/:slug', checkAuth, tagController.getTagProducts);

module.exports = router; 