const bcrypt = require('bcryptjs');
const { sequelize } = require('../models/db');
const { User } = require('../models');
require('dotenv').config();

const createAdmin = async () => {
  try {
    // Verificar conexión a la base de datos
    await sequelize.authenticate();
    console.log('Conexión a la base de datos establecida correctamente.');

    // Datos del administrador
    const adminData = {
      name: 'SuperAdmin',
      email: 'superadmin@nodolatam.dev',
      password: 'superadmin123',  // Esta contraseña será hasheada por el hook beforeCreate
      isAdmin: true,
      about: 'Usuario super administrador de la plataforma.'
    };

    // Verificar si el usuario ya existe
    const existingUser = await User.findOne({ where: { email: adminData.email } });
    
    if (existingUser) {
      console.log('El usuario administrador ya existe.');
      console.log('Actualizando permisos de administrador...');
      
      // Actualizar permisos si el usuario existe pero no es admin
      if (!existingUser.isAdmin) {
        existingUser.isAdmin = true;
        await existingUser.save();
        console.log('Permisos de administrador actualizados correctamente.');
      } else {
        console.log('El usuario ya tiene permisos de administrador.');
      }
    } else {
      // Crear el usuario administrador
      const admin = await User.create(adminData);
      console.log('Usuario administrador creado correctamente:');
      console.log(`- Nombre: ${admin.name}`);
      console.log(`- Email: ${admin.email}`);
      console.log(`- Contraseña: superadmin123`);
      console.log('¡Recuerda cambiar la contraseña después del primer inicio de sesión!');
    }

    // Cerrar la conexión
    await sequelize.close();
    console.log('Conexión a la base de datos cerrada.');
    
  } catch (error) {
    console.error('Error al crear el usuario administrador:', error);
    process.exit(1);
  }
};

// Ejecutar la función
createAdmin(); 